#include <stdio.h>
#include <stdlib.h>

int main() {
    int rows, cols, subRows, subCols;
    scanf("%d %d %d %d", &rows, &cols, &subRows, &subCols);
    int *arrayA = (int *)malloc(rows * cols * sizeof(int));
    for (int i = 0; i < rows * cols; i++) {
        scanf("%d", &arrayA[i]);
    }
    int **matrix = (int **)malloc(rows * sizeof(int *));
    for (int i = 0; i < rows; i++) {
        matrix[i] = (int *)malloc(cols * sizeof(int));
        for (int j = 0; j < cols; j++) {
            matrix[i][j] = arrayA[i * cols + j];
        }
    }
    int maxElement = -2147483648;
    int maxRowIndex = 0;
    int maxColIndex = 0;
    for (int i = 0; i < rows; i++) {
        for (int j = 0; j < cols; j++) {
            if (matrix[i][j] > maxElement) {
                maxElement = matrix[i][j];
                maxRowIndex = i;
                maxColIndex = j;
            }
        }
    }
    int temp = matrix[rows / 2][cols / 2];
    matrix[rows / 2][cols / 2] = maxElement;
    matrix[maxRowIndex][maxColIndex] = temp;
    int **sortedMatrix = (int **)malloc(rows * sizeof(int *));
    for (int i = 0; i < rows; i++) {
        sortedMatrix[i] = (int *)malloc(cols * sizeof(int));
        for (int j = 0; j < cols; j++) {
            sortedMatrix[i][j] = matrix[i][j];
        }
        for (int j = 0; j < cols; j++) {
            for (int k = j + 1; k < cols; k++) {
                if (sortedMatrix[i][j] > sortedMatrix[i][k]) {
                    int temp = sortedMatrix[i][j];
                    sortedMatrix[i][j] = sortedMatrix[i][k];
                    sortedMatrix[i][k] = temp;
                }
            }
        }
        int idx = cols / 2;
        for (int j = 0; j < cols; j++) {
            sortedMatrix[i][j] = sortedMatrix[i][(j + idx) % cols];
        }
    }
    int ***submatrices = (int ***)malloc((rows - subRows + 1) * sizeof(int **));
    for (int i = 0; i < rows - subRows + 1; i++) {
        submatrices[i] = (int **)malloc((cols - subCols + 1) * sizeof(int *));
        for (int j = 0; j < cols - subCols + 1; j++) {
            submatrices[i][j] = (int *)malloc(subRows * subCols * sizeof(int));
            for (int k = 0; k < subRows; k++) {
                for (int l = 0; l < subCols; l++) {
                    submatrices[i][j][k * subCols + l] = sortedMatrix[i + k][j + l];
                }
            }
        }
    }
    int totalSum = 0;
    for (int i = 0; i < rows - subRows + 1; i++) {
        for (int j = 0; j < cols - subCols + 1; j++) {
            int sum = 0;
            for (int k = 0; k < subRows * subCols; k++) {
                sum += submatrices[i][j][k];
            }
            totalSum += sum;
        }
    }
    printf("%d\n", totalSum);

    for (int i = 0; i < rows; i++) {
        free(matrix[i]);
        free(sortedMatrix[i]);
    }
    for (int i = 0; i < rows - subRows + 1; i++) {
        for (int j = 0; j < cols - subCols + 1; j++) {
            free(submatrices[i][j]);
        }
        free(submatrices[i]);
    }
    free(arrayA);
    free(matrix);
    free(sortedMatrix);
    free(submatrices);

    return 0;
}